import tkinter as tk
from tkinter import filedialog, messagebox
from docx import Document
import re

# Define entry_input, entry_output, and entry_symbol as global variables
entry_input = None
entry_output = None
entry_output_name = None
entry_symbol = None

def find_and_copy_sentences_with_symbol(docx_file_path, symbol):
    document = Document(docx_file_path)
    copied_sentences = []
    # Define the regular expression pattern for sentences containing the symbol
    sentence_pattern = re.compile(r'(?<!\S)[^.!?]*?{}[^.!?]*?[.!?](?!\S)'.format(re.escape(symbol)))
    for paragraph in document.paragraphs:
        sentences = sentence_pattern.findall(paragraph.text)
        copied_sentences.extend(sentences)
    return copied_sentences

def export_sentences_to_word(sentences, output_file_path):
    # Create a new Document
    new_document = Document()
    # Add each sentence to the document, followed by a paragraph break
    for sentence in sentences:
        new_document.add_paragraph(sentence)
        new_document.add_paragraph()  # Adds a paragraph break (line break)
    # Save the document
    new_document.save(output_file_path)

def browse_file():
    global entry_input  # Access the global entry_input variable
    filename = filedialog.askopenfilename(filetypes=[("Word files", "*.docx")])
    entry_input.delete(0, tk.END)
    entry_input.insert(0, filename)

def browse_output_directory():
    global entry_output  # Access the global entry_output variable
    output_directory = filedialog.askdirectory()
    entry_output.delete(0, tk.END)
    entry_output.insert(0, output_directory)

def convert_docx():
    global entry_input, entry_output, entry_symbol, entry_output_name  # Access the global entry fields
    input_path = entry_input.get()
    output_directory = entry_output.get()
    output_name = entry_output_name.get()
    symbol_to_search = entry_symbol.get()

    copied_sentences = find_and_copy_sentences_with_symbol(input_path, symbol_to_search)

    output_path = f"{output_directory}/{output_name}.docx"
    export_sentences_to_word(copied_sentences, output_path)
    message = f"Sentences containing '{symbol_to_search}' have been exported to '{output_path}'."
    messagebox.showinfo("File Generated", message)

def main():
    global entry_input, entry_output, entry_output_name, entry_symbol  # Define entry fields as global variables
    root = tk.Tk()
    root.title("DocxHack")  # Updated title

    # Set background color to black
    root.configure(background='black')

    # Create a frame with a red border
    border_frame = tk.Frame(root, bd=5, relief=tk.SUNKEN, bg='red')
    border_frame.pack(expand=True, fill=tk.BOTH, padx=10, pady=10)

    label_input = tk.Label(border_frame, text="Input DOCX Path:")
    label_input.grid(row=0, column=0, padx=10, pady=5)
    entry_input = tk.Entry(border_frame, width=40)
    entry_input.grid(row=0, column=1, padx=10, pady=5)
    btn_browse = tk.Button(border_frame, text="Browse", command=browse_file)
    btn_browse.grid(row=0, column=2, padx=5, pady=5)

    label_symbol = tk.Label(border_frame, text="Symbol to Search:")
    label_symbol.grid(row=1, column=0, padx=10, pady=5)
    entry_symbol = tk.Entry(border_frame, width=40)
    entry_symbol.grid(row=1, column=1, padx=10, pady=5)

    label_output = tk.Label(border_frame, text="Output Directory:")
    label_output.grid(row=2, column=0, padx=10, pady=5)
    entry_output = tk.Entry(border_frame, width=30)
    entry_output.grid(row=2, column=1, padx=10, pady=5)
    btn_output = tk.Button(border_frame, text="Browse", command=browse_output_directory)
    btn_output.grid(row=2, column=2, padx=5, pady=5)

    label_output_name = tk.Label(border_frame, text="Output File Name:")
    label_output_name.grid(row=3, column=0, padx=10, pady=5)
    entry_output_name = tk.Entry(border_frame, width=30)
    entry_output_name.grid(row=3, column=1, padx=10, pady=5)

    btn_convert = tk.Button(border_frame, text="Extract Sentences", command=convert_docx)
    btn_convert.grid(row=4, column=1, pady=10)

    root.mainloop()

if __name__ == "__main__":
    main()
